<?php
App::uses('AppController', 'Controller');

class StatsController extends AppController
{
    public $helpers = array('Text');
    public $layout = 'member';

    public function beforeFilter()
    {
        parent::beforeFilter();
        $this->Auth->allow('view');
    }

    public function view($req_alias = null)
    {
        $this->layout = 'frontend';

        if (!$req_alias) {
            return $this->redirect('/');
        }

        $link = $this->Stat->Link->findByAlias($req_alias);
        if (!$link) {
            throw new NotFoundException(__('404 Not Found'));
        }
        $this->set('link', $link);

        $user = $this->Stat->User->findById($link['Link']['user_id']);
        if (!$user) {
            throw new NotFoundException(__('404 Not Found'));
        }
        $this->set('user', $user);

        $plan_id = $user['User']['plan_id'];
        if ($link['Link']['user_id'] == 1) {
            $plan_id = Configure::read('Option.default_public_plan');
        }

        $user_plan = $this->Stat->User->Plan->findById($plan_id);
        if (!$user_plan) {
            throw new NotFoundException(__('404 Not Found'));
        }
        $this->set('user_plan', $user_plan);





        $short_url = Router::url('/' . $req_alias, true);
        $statModel = $this->Stat;

        /**
         * facebook_count
         */
        $facebook_count = Cache::remember($req_alias . '_facebook_count', function () use ($statModel, $short_url) {
            return $statModel->facebook_count($short_url);
        }, 'short');
        $this->set('facebook_count', $facebook_count);

        /**
         * google_plus_count
         */
        $google_plus_count = Cache::remember($req_alias . '_google_plus_count', function () use ($statModel, $short_url) {
            return $statModel->google_plus_count($short_url);
        }, 'short');
        $this->set('google_plus_count', $google_plus_count);

        /**
         * pinterest_count
         */
        $pinterest_count = Cache::remember($req_alias . '_pinterest_count', function () use ($statModel, $short_url) {
            return $statModel->pinterest_count($short_url);
        }, 'short');
        $this->set('pinterest_count', $pinterest_count);

        /**
         * linkedin_count
         */
        $linkedin_count = Cache::remember($req_alias . '_linkedin_count', function () use ($statModel, $short_url) {
            return $statModel->linkedin_count($short_url);
        }, 'short');
        $this->set('linkedin_count', $linkedin_count);

        /**
         * stumbledupon_count
         */
        $stumbledupon_count = Cache::remember($req_alias . '_stumbledupon_count', function () use ($statModel, $short_url) {
            return $statModel->stumbledupon_count($short_url);
        }, 'short');
        $this->set('stumbledupon_count', $stumbledupon_count);

        /**
         * reddit_count
         */
        $reddit_count = Cache::remember($req_alias . '_reddit_count', function () use ($statModel, $short_url) {
            return $statModel->reddit_count($short_url);
        }, 'short');
        $this->set('reddit_count', $reddit_count);

        $linksStats = $this->Stat->find('all', array(
            'conditions' => array(
                'Stat.user_id' => $link['Link']['user_id'],
                'Stat.link_id' => $link['Link']['id'],
                'Stat.created BETWEEN (NOW() - INTERVAL 30 DAY) AND NOW()'
            ),
            'fields' => array('DATE_FORMAT(Stat.created,"%d-%m-%Y") AS statDate', 'COUNT(DATE_FORMAT(Stat.created,"%d-%m-%Y")) AS statDateCount'),
            'order' => array(
                'Stat.created' => 'DESC'
            ),
            'group' => array('statDate'),
        ));
        $this->set('linksStats', $linksStats);

        $link_countries = $this->Stat->find('all', array(
            'conditions' => array(
                'Stat.user_id' => $link['Link']['user_id'],
                'Stat.link_id' => $link['Link']['id'],
            ),
            'fields' => array('Stat.country', 'COUNT(Stat.country) AS country_num'),
            'order' => array(
                'country_num' => 'desc'
            ),
            'group' => array('Stat.country'),
        ));
        $this->set('link_countries', $link_countries);

        $link_continents = $this->Stat->find('all', array(
            'conditions' => array(
                'Stat.user_id' => $link['Link']['user_id'],
                'Stat.link_id' => $link['Link']['id'],
            ),
            'fields' => array('Stat.continent', 'COUNT(Stat.continent) AS continent_num'),
            'order' => array(
                'continent_num' => 'desc'
            ),
            'group' => array('Stat.continent'),
        ));
        $this->set('link_continents', $link_continents);

        $link_states = $this->Stat->find('all', array(
            'conditions' => array(
                'Stat.user_id' => $link['Link']['user_id'],
                'Stat.link_id' => $link['Link']['id'],
            ),
            'fields' => array('Stat.state', 'COUNT(Stat.state) AS state_num'),
            'order' => array(
                'state_num' => 'desc'
            ),
            'group' => array('Stat.state'),
        ));
        $this->set('link_states', $link_states);

        $link_cities = $this->Stat->find('all', array(
            'conditions' => array(
                'Stat.user_id' => $link['Link']['user_id'],
                'Stat.link_id' => $link['Link']['id'],
            ),
            'fields' => array('Stat.city', 'COUNT(Stat.city) AS city_num'),
            'order' => array(
                'city_num' => 'desc'
            ),
            'group' => array('Stat.city'),
        ));
        $this->set('link_cities', $link_cities);

        $link_browsers = $this->Stat->find('all', array(
            'conditions' => array(
                'Stat.user_id' => $link['Link']['user_id'],
                'Stat.link_id' => $link['Link']['id'],
            ),
            'fields' => array('Stat.browser', 'COUNT(Stat.browser) AS browser_num'),
            'order' => array(
                'browser_num' => 'desc'
            ),
            'group' => array('Stat.browser'),
        ));
        $this->set('link_browsers', $link_browsers);

        $link_platforms = $this->Stat->find('all', array(
            'conditions' => array(
                'Stat.user_id' => $link['Link']['user_id'],
                'Stat.link_id' => $link['Link']['id'],
            ),
            'fields' => array('Stat.platform', 'COUNT(Stat.platform) AS platform_num'),
            'order' => array(
                'platform_num' => 'desc'
            ),
            'group' => array('Stat.platform'),
        ));
        $this->set('link_platforms', $link_platforms);

        $link_referrers = $this->Stat->find('all', array(
            'conditions' => array(
                'Stat.user_id' => $link['Link']['user_id'],
                'Stat.link_id' => $link['Link']['id'],
            ),
            'fields' => array(
                "COUNT(Stat.referer) AS num", "Stat.referer_domain"
            ),
            /*
              'fields' => array(
              "COUNT(Stat.referer) AS num", "SUBSTRING_INDEX(REPLACE(REPLACE(Stat.referer,'http://',''),'https://',''),'/',1) AS domain"
              ),
             */
            'order' => array(
                'num' => 'desc'
            ),
            'group' => array('Stat.referer_domain'),
        ));
        $this->set('link_referrers', $link_referrers);



        $link_devices = $this->Stat->find('all', array(
            'conditions' => array(
                'Stat.user_id' => $link['Link']['user_id'],
                'Stat.link_id' => $link['Link']['id'],
            ),
            'fields' => array('Stat.device_type', 'COUNT(Stat.device_type) AS num'),
            'order' => array(
                'num' => 'desc'
            ),
            'group' => array('Stat.device_type'),
        ));
        $this->set('link_devices', $link_devices);

        $link_brands = $this->Stat->find('all', array(
            'conditions' => array(
                'Stat.user_id' => $link['Link']['user_id'],
                'Stat.link_id' => $link['Link']['id'],
                'OR' => array(
                    'Stat.is_mobile' => 1,
                    'Stat.is_tablet' => 1
                )
            ),
            'fields' => array('Stat.device_brand', 'COUNT(Stat.device_brand) AS num'),
            'order' => array(
                'num' => 'desc'
            ),
            'group' => array('Stat.device_brand'),
        ));
        $this->set('link_brands', $link_brands);

        $link_device_names = $this->Stat->find('all', array(
            'conditions' => array(
                'Stat.user_id' => $link['Link']['user_id'],
                'Stat.link_id' => $link['Link']['id'],
                'OR' => array(
                    'Stat.is_mobile' => 1,
                    'Stat.is_tablet' => 1
                )
            ),
            'fields' => array('Stat.device_name', 'COUNT(Stat.device_name) AS num'),
            'order' => array(
                'num' => 'desc'
            ),
            'group' => array('Stat.device_name'),
        ));
        $this->set('link_device_names', $link_device_names);

        $link_languages = $this->Stat->find('all', array(
            'conditions' => array(
                'Stat.user_id' => $link['Link']['user_id'],
                'Stat.link_id' => $link['Link']['id'],
            ),
            'fields' => array('Stat.language', 'COUNT(Stat.language) AS num'),
            'order' => array(
                'num' => 'desc'
            ),
            'group' => array('Stat.language'),
        ));
        $this->set('link_languages', $link_languages);
    }

    public function members_index()
    {
        $this->set('website_title', 'All Stats');
        //$this->Stat->recursive = 0;
        // http://book.cakephp.org/2.0/en/models/associations-linking-models-together.html#joining-tables
        $this->paginate = array(
            'joins' => array(
                array('table' => 'links',
                    'alias' => 'Link',
                    'type' => 'LEFT',
                    'conditions' => array(
                        'Stat.link_id = Link.id',
                    )
                )
            ),
            'conditions' => array('Link.user_id' => $this->Auth->user('id')),
            'fields' => array('Link.id', 'Link.created', 'Link.alias', 'Link.description', 'Link.alias', 'Link.title', 'Link.clicks', 'Stat.id'),
            'limit' => 10,
            'order' => array(
                'Link.created' => 'desc'
            ),
            'group' => array('Link.id'),
        );
        $data = $this->paginate('Stat');

        $this->set('stats', $data);
    }

    public function admin_view($id = null)
    {
        $this->layout = 'admin';

        $this->set('website_title', 'Link Stats');

        if (!$id) {
            throw new NotFoundException(__('Invalid link'));
        }
        $link = $this->Stat->Link->findById($id);
        if (!$link) {
            throw new NotFoundException(__('Invalid link'));
        }
        $this->set('link', $link);

        $user = $this->Stat->User->findById($link['Link']['user_id']);
        if (!$user) {
            throw new NotFoundException(__('Invalid User'));
        }
        $this->set('user', $user);

        /**
         * Link stats for last 30 days
         */
        $linksStats = $this->Stat->find('all', array(
            'conditions' => array(
                'Stat.link_id' => $id,
                'Stat.created BETWEEN (NOW() - INTERVAL 30 DAY) AND NOW()'
            ),
            'fields' => array('DATE_FORMAT(Stat.created,"%d-%m-%Y") AS statDate', 'COUNT(DATE_FORMAT(Stat.created,"%d-%m-%Y")) AS statDateCount'),
            'order' => array(
                'Stat.created' => 'DESC'
            ),
            'group' => array('statDate'),
        ));
        $linksStats = Hash::combine($linksStats, '{n}.0.statDate', '{n}.0.statDateCount');
        $this->set('linksStats', $linksStats);

        /**
         * Link countries stats
         */
        $link_countries = $this->Stat->find('all', array(
            'conditions' => array('Stat.link_id' => $id),
            'fields' => array('Stat.country', 'COUNT(Stat.country) AS country_num'),
            'order' => array(
                'country_num' => 'desc'
            ),
            'group' => array('Stat.country'),
        ));
        $countries = Hash::combine($link_countries, '{n}.Stat.country', '{n}.0.country_num');
        $this->set('countries', $countries);

        /**
         * Link continents stats
         */
        $link_continents = $this->Stat->find('all', array(
            'conditions' => array('Stat.link_id' => $id),
            'fields' => array('Stat.continent', 'COUNT(Stat.continent) AS continent_num'),
            'order' => array(
                'continent_num' => 'desc'
            ),
            'group' => array('Stat.continent'),
        ));
        $continents = Hash::combine($link_continents, '{n}.Stat.continent', '{n}.0.continent_num');
        $this->set('continents', $continents);

        /**
         * Link states stats
         */
        $link_states = $this->Stat->find('all', array(
            'conditions' => array('Stat.link_id' => $id),
            'fields' => array('Stat.state', 'COUNT(Stat.state) AS state_num'),
            'order' => array(
                'state_num' => 'desc'
            ),
            'group' => array('Stat.state'),
        ));
        $states = Hash::combine($link_states, '{n}.Stat.state', '{n}.0.state_num');
        $this->set('states', $states);

        /**
         * Link cities stats
         */
        $link_cities = $this->Stat->find('all', array(
            'conditions' => array('Stat.link_id' => $id),
            'fields' => array('Stat.city', 'COUNT(Stat.city) AS city_num'),
            'order' => array(
                'city_num' => 'desc'
            ),
            'group' => array('Stat.city'),
        ));
        $cities = Hash::combine($link_cities, '{n}.Stat.city', '{n}.0.city_num');
        $this->set('cities', $cities);

        /**
         * Link browsers stats
         */
        $link_browsers = $this->Stat->find('all', array(
            'conditions' => array('Stat.link_id' => $id),
            'fields' => array('Stat.browser', 'COUNT(Stat.browser) AS browser_num'),
            'order' => array(
                'browser_num' => 'desc'
            ),
            'group' => array('Stat.browser'),
        ));
        $browsers = Hash::combine($link_browsers, '{n}.Stat.browser', '{n}.0.browser_num');
        $this->set('browsers', $browsers);

        /**
         * Link platforms stats
         */
        $link_platforms = $this->Stat->find('all', array(
            'conditions' => array('Stat.link_id' => $id),
            'fields' => array('Stat.platform', 'COUNT(Stat.platform) AS platform_num'),
            'order' => array(
                'platform_num' => 'desc'
            ),
            'group' => array('Stat.platform'),
        ));
        $platforms = Hash::combine($link_platforms, '{n}.Stat.platform', '{n}.0.platform_num');
        $this->set('platforms', $platforms);

        /**
         * Link referrers stats
         */
        $link_referrers = $this->Stat->find('all', array(
            'conditions' => array('Stat.link_id' => $id),
            'fields' => array(
                "COUNT(Stat.referer) AS num", "Stat.referer_domain"
            ),
            /*
              'fields' => array(
              "COUNT(Stat.referer) AS num", "SUBSTRING_INDEX(REPLACE(REPLACE(Stat.referer,'http://',''),'https://',''),'/',1) AS domain"
              ),
             */
            'order' => array(
                'num' => 'desc'
            ),
            'group' => array('Stat.referer_domain'),
        ));
        $referrers = Hash::combine($link_referrers, '{n}.Stat.referer_domain', '{n}.0.num');
        $this->set('referrers', $referrers);

        /**
         * Link device types stats
         */
        $link_devices = $this->Stat->find('all', array(
            'conditions' => array('Stat.link_id' => $id),
            'fields' => array('Stat.device_type', 'COUNT(Stat.device_type) AS num'),
            'order' => array(
                'num' => 'desc'
            ),
            'group' => array('Stat.device_type'),
        ));
        $devices = Hash::combine($link_devices, '{n}.Stat.device_type', '{n}.0.num');
        $this->set('devices', $devices);

        /**
         * Link brands stats
         */
        $link_brands = $this->Stat->find('all', array(
            'conditions' => array(
                'Stat.link_id' => $id,
                'OR' => array(
                    'Stat.is_mobile' => 1,
                    'Stat.is_tablet' => 1
                )
            ),
            'fields' => array('Stat.device_brand', 'COUNT(Stat.device_brand) AS num'),
            'order' => array(
                'num' => 'desc'
            ),
            'group' => array('Stat.device_brand'),
        ));
        $brands = Hash::combine($link_brands, '{n}.Stat.device_brand', '{n}.0.num');
        $this->set('brands', $brands);

        /**
         * Link device names stats
         */
        $link_device_names = $this->Stat->find('all', array(
            'conditions' => array(
                'Stat.link_id' => $id,
                'OR' => array(
                    'Stat.is_mobile' => 1,
                    'Stat.is_tablet' => 1
                )
            ),
            'fields' => array('Stat.device_name', 'COUNT(Stat.device_name) AS num'),
            'order' => array(
                'num' => 'desc'
            ),
            'group' => array('Stat.device_name'),
        ));
        $device_names = Hash::combine($link_device_names, '{n}.Stat.device_name', '{n}.0.num');
        $this->set('device_names', $device_names);

        /**
         * Link languages stats
         */
        $link_languages = $this->Stat->find('all', array(
            'conditions' => array('Stat.link_id' => $id),
            'fields' => array('Stat.language', 'COUNT(Stat.language) AS num'),
            'order' => array(
                'num' => 'desc'
            ),
            'group' => array('Stat.language'),
        ));
        $languages = Hash::combine($link_languages, '{n}.Stat.language', '{n}.0.num');
        $this->set('languages', $languages);
    }

    public function admin_location()
    {
        $this->layout = 'admin';

        $this->set('website_title', 'Stat Locations');

        //Transform POST into GET
        if (($this->request->is('post') || $this->request->is('put')) && isset($this->request->data['Filter'])) {
            $date_from = $this->request->data['Filter']['date_from'];
            $date_from_str = $date_from['year'] . '-' . $date_from['month'] . '-' . $date_from['day'] . ' 00:00:00';
            $date_to = $this->request->data['Filter']['date_to'];
            $date_to_str = $date_to['year'] . '-' . $date_to['month'] . '-' . $date_to['day'] . ' 00:00:00';
        } else {
            $this->request->data['Filter']['date_from'] = date('Y-m-d', strtotime('-1 month'));
            $this->request->data['Filter']['date_to'] = date('Y-m-d', strtotime('now'));
            $date_from_str = date('Y-m-d H:i:s', strtotime('last month'));
            $date_to_str = date('Y-m-d H:i:s', strtotime('now'));
        }

        $this->set('date_from_str', $date_from_str);
        $this->set('date_to_str', $date_to_str);



        $linksStats = $this->Stat->find('all', array(
            'conditions' => array(
                'Stat.created BETWEEN "' . $date_from_str . '" AND "' . $date_to_str . '"'
            //'Stat.created BETWEEN (NOW() - INTERVAL 30 DAY) AND NOW()'
            ),
            'fields' => array('DATE_FORMAT(Stat.created,"%d-%m-%Y") AS statDate', 'COUNT(DATE_FORMAT(Stat.created,"%d-%m-%Y")) AS statDateCount'),
            'order' => array(
                'Stat.created' => 'DESC'
            ),
            'group' => array('statDate'),
        ));
        $this->set('linksStats', $linksStats);

        $link_countries = $this->Stat->find('all', array(
            'conditions' => array(
                'Stat.created BETWEEN "' . $date_from_str . '" AND "' . $date_to_str . '"'
            ),
            'fields' => array('Stat.country', 'COUNT(Stat.country) AS country_num'),
            'order' => array(
                'country_num' => 'desc'
            ),
            'group' => array('Stat.country'),
        ));
        $this->set('link_countries', $link_countries);

        $link_continents = $this->Stat->find('all', array(
            'conditions' => array(
                'Stat.created BETWEEN "' . $date_from_str . '" AND "' . $date_to_str . '"'
            ),
            'fields' => array('Stat.continent', 'COUNT(Stat.continent) AS continent_num'),
            'order' => array(
                'continent_num' => 'desc'
            ),
            'group' => array('Stat.continent'),
        ));
        $this->set('link_continents', $link_continents);

        $link_states = $this->Stat->find('all', array(
            'conditions' => array(
                'Stat.created BETWEEN "' . $date_from_str . '" AND "' . $date_to_str . '"'
            ),
            'fields' => array('Stat.state', 'COUNT(Stat.state) AS state_num'),
            'order' => array(
                'state_num' => 'desc'
            ),
            'group' => array('Stat.state'),
        ));
        $this->set('link_states', $link_states);

        $link_cities = $this->Stat->find('all', array(
            'conditions' => array(
                'Stat.created BETWEEN "' . $date_from_str . '" AND "' . $date_to_str . '"'
            ),
            'fields' => array('Stat.city', 'COUNT(Stat.city) AS city_num'),
            'order' => array(
                'city_num' => 'desc'
            ),
            'group' => array('Stat.city'),
        ));
        $this->set('link_cities', $link_cities);
    }

    public function admin_referrer()
    {
        $this->layout = 'admin';

        $this->set('website_title', 'Stat Locations');

        //Transform POST into GET
        if (($this->request->is('post') || $this->request->is('put')) && isset($this->request->data['Filter'])) {
            $date_from = $this->request->data['Filter']['date_from'];
            $date_from_str = $date_from['year'] . '-' . $date_from['month'] . '-' . $date_from['day'] . ' 00:00:00';
            $date_to = $this->request->data['Filter']['date_to'];
            $date_to_str = $date_to['year'] . '-' . $date_to['month'] . '-' . $date_to['day'] . ' 00:00:00';
        } else {
            $this->request->data['Filter']['date_from'] = date('Y-m-d', strtotime('-1 month'));
            $this->request->data['Filter']['date_to'] = date('Y-m-d', strtotime('now'));
            $date_from_str = date('Y-m-d H:i:s', strtotime('last month'));
            $date_to_str = date('Y-m-d H:i:s', strtotime('now'));
        }

        $this->set('date_from_str', $date_from_str);
        $this->set('date_to_str', $date_to_str);


        $link_referrers = $this->Stat->find('all', array(
            'conditions' => array(
                'Stat.created BETWEEN "' . $date_from_str . '" AND "' . $date_to_str . '"'
            ),
            'fields' => array(
                "COUNT(Stat.referer) AS num", "Stat.referer_domain"
            ),
            /*
              'fields' => array(
              "COUNT(Stat.referer) AS num", "SUBSTRING_INDEX(REPLACE(REPLACE(Stat.referer,'http://',''),'https://',''),'/',1) AS domain"
              ),
             */
            'order' => array(
                'num' => 'desc'
            ),
            'group' => array('Stat.referer_domain'),
        ));
        $this->set('link_referrers', $link_referrers);
    }

    public function admin_browser()
    {
        $this->layout = 'admin';

        $this->set('website_title', 'Stat Locations');

        //Transform POST into GET
        if (($this->request->is('post') || $this->request->is('put')) && isset($this->request->data['Filter'])) {
            $date_from = $this->request->data['Filter']['date_from'];
            $date_from_str = $date_from['year'] . '-' . $date_from['month'] . '-' . $date_from['day'] . ' 00:00:00';
            $date_to = $this->request->data['Filter']['date_to'];
            $date_to_str = $date_to['year'] . '-' . $date_to['month'] . '-' . $date_to['day'] . ' 00:00:00';
        } else {
            $this->request->data['Filter']['date_from'] = date('Y-m-d', strtotime('-1 month'));
            $this->request->data['Filter']['date_to'] = date('Y-m-d', strtotime('now'));
            $date_from_str = date('Y-m-d H:i:s', strtotime('last month'));
            $date_to_str = date('Y-m-d H:i:s', strtotime('now'));
        }

        $this->set('date_from_str', $date_from_str);
        $this->set('date_to_str', $date_to_str);


        $link_browsers = $this->Stat->find('all', array(
            'conditions' => array(
                'Stat.created BETWEEN "' . $date_from_str . '" AND "' . $date_to_str . '"'
            ),
            'fields' => array('Stat.browser', 'COUNT(Stat.browser) AS browser_num'),
            'order' => array(
                'browser_num' => 'desc'
            ),
            'group' => array('Stat.browser'),
        ));
        $this->set('link_browsers', $link_browsers);
    }

    public function admin_platform()
    {
        $this->layout = 'admin';

        $this->set('website_title', 'Stat Locations');

        //Transform POST into GET
        if (($this->request->is('post') || $this->request->is('put')) && isset($this->request->data['Filter'])) {
            $date_from = $this->request->data['Filter']['date_from'];
            $date_from_str = $date_from['year'] . '-' . $date_from['month'] . '-' . $date_from['day'] . ' 00:00:00';
            $date_to = $this->request->data['Filter']['date_to'];
            $date_to_str = $date_to['year'] . '-' . $date_to['month'] . '-' . $date_to['day'] . ' 00:00:00';
        } else {
            $this->request->data['Filter']['date_from'] = date('Y-m-d', strtotime('-1 month'));
            $this->request->data['Filter']['date_to'] = date('Y-m-d', strtotime('now'));
            $date_from_str = date('Y-m-d H:i:s', strtotime('last month'));
            $date_to_str = date('Y-m-d H:i:s', strtotime('now'));
        }

        $this->set('date_from_str', $date_from_str);
        $this->set('date_to_str', $date_to_str);


        $link_platforms = $this->Stat->find('all', array(
            'conditions' => array(
                'Stat.created BETWEEN "' . $date_from_str . '" AND "' . $date_to_str . '"'
            ),
            'fields' => array('Stat.platform', 'COUNT(Stat.platform) AS platform_num'),
            'order' => array(
                'platform_num' => 'desc'
            ),
            'group' => array('Stat.platform'),
        ));
        $this->set('link_platforms', $link_platforms);
    }

    public function admin_language()
    {
        $this->layout = 'admin';

        $this->set('website_title', 'Stat Locations');

        //Transform POST into GET
        if (($this->request->is('post') || $this->request->is('put')) && isset($this->request->data['Filter'])) {
            $date_from = $this->request->data['Filter']['date_from'];
            $date_from_str = $date_from['year'] . '-' . $date_from['month'] . '-' . $date_from['day'] . ' 00:00:00';
            $date_to = $this->request->data['Filter']['date_to'];
            $date_to_str = $date_to['year'] . '-' . $date_to['month'] . '-' . $date_to['day'] . ' 00:00:00';
        } else {
            $this->request->data['Filter']['date_from'] = date('Y-m-d', strtotime('-1 month'));
            $this->request->data['Filter']['date_to'] = date('Y-m-d', strtotime('now'));
            $date_from_str = date('Y-m-d H:i:s', strtotime('last month'));
            $date_to_str = date('Y-m-d H:i:s', strtotime('now'));
        }

        $this->set('date_from_str', $date_from_str);
        $this->set('date_to_str', $date_to_str);


        $link_languages = $this->Stat->find('all', array(
            'conditions' => array(
                'Stat.created BETWEEN "' . $date_from_str . '" AND "' . $date_to_str . '"'
            ),
            'fields' => array('Stat.language', 'COUNT(Stat.language) AS num'),
            'order' => array(
                'num' => 'desc'
            ),
            'group' => array('Stat.language'),
        ));
        $this->set('link_languages', $link_languages);
    }

    public function admin_device()
    {
        $this->layout = 'admin';

        $this->set('website_title', 'Stat Locations');

        //Transform POST into GET
        if (($this->request->is('post') || $this->request->is('put')) && isset($this->request->data['Filter'])) {
            $date_from = $this->request->data['Filter']['date_from'];
            $date_from_str = $date_from['year'] . '-' . $date_from['month'] . '-' . $date_from['day'] . ' 00:00:00';
            $date_to = $this->request->data['Filter']['date_to'];
            $date_to_str = $date_to['year'] . '-' . $date_to['month'] . '-' . $date_to['day'] . ' 00:00:00';
        } else {
            $this->request->data['Filter']['date_from'] = date('Y-m-d', strtotime('-1 month'));
            $this->request->data['Filter']['date_to'] = date('Y-m-d', strtotime('now'));
            $date_from_str = date('Y-m-d H:i:s', strtotime('last month'));
            $date_to_str = date('Y-m-d H:i:s', strtotime('now'));
        }

        $this->set('date_from_str', $date_from_str);
        $this->set('date_to_str', $date_to_str);


        $link_devices = $this->Stat->find('all', array(
            'conditions' => array(
                'Stat.created BETWEEN "' . $date_from_str . '" AND "' . $date_to_str . '"'
            ),
            'fields' => array('Stat.device_type', 'COUNT(Stat.device_type) AS num'),
            'order' => array(
                'num' => 'desc'
            ),
            'group' => array('Stat.device_type'),
        ));
        $this->set('link_devices', $link_devices);
    }

    public function admin_mobile()
    {
        $this->layout = 'admin';

        $this->set('website_title', 'Stat Locations');

        //Transform POST into GET
        if (($this->request->is('post') || $this->request->is('put')) && isset($this->request->data['Filter'])) {
            $date_from = $this->request->data['Filter']['date_from'];
            $date_from_str = $date_from['year'] . '-' . $date_from['month'] . '-' . $date_from['day'] . ' 00:00:00';
            $date_to = $this->request->data['Filter']['date_to'];
            $date_to_str = $date_to['year'] . '-' . $date_to['month'] . '-' . $date_to['day'] . ' 00:00:00';
        } else {
            $this->request->data['Filter']['date_from'] = date('Y-m-d', strtotime('-1 month'));
            $this->request->data['Filter']['date_to'] = date('Y-m-d', strtotime('now'));
            $date_from_str = date('Y-m-d H:i:s', strtotime('last month'));
            $date_to_str = date('Y-m-d H:i:s', strtotime('now'));
        }

        $this->set('date_from_str', $date_from_str);
        $this->set('date_to_str', $date_to_str);


        $link_brands = $this->Stat->find('all', array(
            'conditions' => array(
                'Stat.created BETWEEN "' . $date_from_str . '" AND "' . $date_to_str . '"',
                'OR' => array(
                    'Stat.is_mobile' => 1,
                    'Stat.is_tablet' => 1
                )
            ),
            'fields' => array('Stat.device_brand', 'COUNT(Stat.device_brand) AS num'),
            'order' => array(
                'num' => 'desc'
            ),
            'group' => array('Stat.device_brand'),
        ));
        $this->set('link_brands', $link_brands);

        $link_device_names = $this->Stat->find('all', array(
            'conditions' => array(
                'Stat.created BETWEEN "' . $date_from_str . '" AND "' . $date_to_str . '"',
                'OR' => array(
                    'Stat.is_mobile' => 1,
                    'Stat.is_tablet' => 1
                )
            ),
            'fields' => array('Stat.device_name', 'COUNT(Stat.device_name) AS num'),
            'order' => array(
                'num' => 'desc'
            ),
            'group' => array('Stat.device_name'),
        ));
        $this->set('link_device_names', $link_device_names);
    }

    public function members_view($id = null)
    {
        $this->set('website_title', 'Link Stats');

        if (!$id) {
            throw new NotFoundException(__('Invalid link'));
        }
        $link = $this->Stat->Link->findById($id);
        if (!$link) {
            throw new NotFoundException(__('Invalid link'));
        }
        $this->set('link', $link);

        $user = $this->Stat->User->findById($link['Link']['user_id']);
        if (!$user) {
            throw new NotFoundException(__('Invalid User'));
        }
        $this->set('user', $user);

        $user_plan = $this->Stat->User->Plan->findById($user['User']['plan_id']);
        if (!$user_plan) {
            throw new NotFoundException(__('404 Not Found'));
        }
        $this->set('user_plan', $user_plan);

        $linksStats = $this->Stat->find('all', array(
            'conditions' => array(
                'Stat.user_id' => $this->Auth->user('id'),
                'Stat.link_id' => $id,
                'Stat.created BETWEEN (NOW() - INTERVAL 30 DAY) AND NOW()'
            ),
            'fields' => array('DATE_FORMAT(Stat.created,"%d-%m-%Y") AS statDate', 'COUNT(DATE_FORMAT(Stat.created,"%d-%m-%Y")) AS statDateCount'),
            'order' => array(
                'Stat.created' => 'DESC'
            ),
            'group' => array('statDate'),
        ));
        $this->set('linksStats', $linksStats);

        $link_countries = $this->Stat->find('all', array(
            'conditions' => array(
                'Stat.user_id' => $this->Auth->user('id'),
                'Stat.link_id' => $id
            ),
            'fields' => array('Stat.country', 'COUNT(Stat.country) AS country_num'),
            'order' => array(
                'country_num' => 'desc'
            ),
            'group' => array('Stat.country'),
        ));
        $this->set('link_countries', $link_countries);

        $link_continents = $this->Stat->find('all', array(
            'conditions' => array(
                'Stat.user_id' => $this->Auth->user('id'),
                'Stat.link_id' => $id
            ),
            'fields' => array('Stat.continent', 'COUNT(Stat.continent) AS continent_num'),
            'order' => array(
                'continent_num' => 'desc'
            ),
            'group' => array('Stat.continent'),
        ));
        $this->set('link_continents', $link_continents);

        $link_states = $this->Stat->find('all', array(
            'conditions' => array(
                'Stat.user_id' => $this->Auth->user('id'),
                'Stat.link_id' => $id
            ),
            'fields' => array('Stat.state', 'COUNT(Stat.state) AS state_num'),
            'order' => array(
                'state_num' => 'desc'
            ),
            'group' => array('Stat.state'),
        ));
        $this->set('link_states', $link_states);

        $link_cities = $this->Stat->find('all', array(
            'conditions' => array(
                'Stat.user_id' => $this->Auth->user('id'),
                'Stat.link_id' => $id
            ),
            'fields' => array('Stat.city', 'COUNT(Stat.city) AS city_num'),
            'order' => array(
                'city_num' => 'desc'
            ),
            'group' => array('Stat.city'),
        ));
        $this->set('link_cities', $link_cities);

        $link_browsers = $this->Stat->find('all', array(
            'conditions' => array(
                'Stat.user_id' => $this->Auth->user('id'),
                'Stat.link_id' => $id
            ),
            'fields' => array('Stat.browser', 'COUNT(Stat.browser) AS browser_num'),
            'order' => array(
                'browser_num' => 'desc'
            ),
            'group' => array('Stat.browser'),
        ));
        $this->set('link_browsers', $link_browsers);

        $link_platforms = $this->Stat->find('all', array(
            'conditions' => array(
                'Stat.user_id' => $this->Auth->user('id'),
                'Stat.link_id' => $id
            ),
            'fields' => array('Stat.platform', 'COUNT(Stat.platform) AS platform_num'),
            'order' => array(
                'platform_num' => 'desc'
            ),
            'group' => array('Stat.platform'),
        ));
        $this->set('link_platforms', $link_platforms);

        $link_referrers = $this->Stat->find('all', array(
            'conditions' => array(
                'Stat.user_id' => $this->Auth->user('id'),
                'Stat.link_id' => $id
            ),
            'fields' => array(
                "COUNT(Stat.referer) AS num", "Stat.referer_domain"
            ),
            /*
              'fields' => array(
              "COUNT(Stat.referer) AS num", "SUBSTRING_INDEX(REPLACE(REPLACE(Stat.referer,'http://',''),'https://',''),'/',1) AS domain"
              ),
             */
            'order' => array(
                'num' => 'desc'
            ),
            'group' => array('Stat.referer_domain'),
        ));
        $this->set('link_referrers', $link_referrers);



        $link_devices = $this->Stat->find('all', array(
            'conditions' => array(
                'Stat.user_id' => $this->Auth->user('id'),
                'Stat.link_id' => $id
            ),
            'fields' => array('Stat.device_type', 'COUNT(Stat.device_type) AS num'),
            'order' => array(
                'num' => 'desc'
            ),
            'group' => array('Stat.device_type'),
        ));
        $this->set('link_devices', $link_devices);

        $link_brands = $this->Stat->find('all', array(
            'conditions' => array(
                'Stat.user_id' => $this->Auth->user('id'),
                'Stat.link_id' => $id,
                'OR' => array(
                    'Stat.is_mobile' => 1,
                    'Stat.is_tablet' => 1
                )
            ),
            'fields' => array('Stat.device_brand', 'COUNT(Stat.device_brand) AS num'),
            'order' => array(
                'num' => 'desc'
            ),
            'group' => array('Stat.device_brand'),
        ));
        $this->set('link_brands', $link_brands);

        $link_device_names = $this->Stat->find('all', array(
            'conditions' => array(
                'Stat.user_id' => $this->Auth->user('id'),
                'Stat.link_id' => $id,
                'OR' => array(
                    'Stat.is_mobile' => 1,
                    'Stat.is_tablet' => 1
                )
            ),
            'fields' => array('Stat.device_name', 'COUNT(Stat.device_name) AS num'),
            'order' => array(
                'num' => 'desc'
            ),
            'group' => array('Stat.device_name'),
        ));
        $this->set('link_device_names', $link_device_names);

        $link_languages = $this->Stat->find('all', array(
            'conditions' => array(
                'Stat.user_id' => $this->Auth->user('id'),
                'Stat.link_id' => $id
            ),
            'fields' => array('Stat.language', 'COUNT(Stat.language) AS num'),
            'order' => array(
                'num' => 'desc'
            ),
            'group' => array('Stat.language'),
        ));
        $this->set('link_languages', $link_languages);
    }

    public function members_location()
    {
        $this->set('website_title', 'Stat Locations');

        //Transform POST into GET
        if (($this->request->is('post') || $this->request->is('put')) && isset($this->request->data['Filter'])) {
            $date_from = $this->request->data['Filter']['date_from'];
            $date_from_str = $date_from['year'] . '-' . $date_from['month'] . '-' . $date_from['day'] . ' 00:00:00';
            $date_to = $this->request->data['Filter']['date_to'];
            $date_to_str = $date_to['year'] . '-' . $date_to['month'] . '-' . $date_to['day'] . ' 00:00:00';
        } else {
            $this->request->data['Filter']['date_from'] = date('Y-m-d', strtotime('-1 month'));
            $this->request->data['Filter']['date_to'] = date('Y-m-d', strtotime('now'));
            $date_from_str = date('Y-m-d H:i:s', strtotime('last month'));
            $date_to_str = date('Y-m-d H:i:s', strtotime('now'));
        }

        $this->set('date_from_str', $date_from_str);
        $this->set('date_to_str', $date_to_str);



        $linksStats = $this->Stat->find('all', array(
            'conditions' => array(
                'Stat.user_id' => $this->Auth->user('id'),
                'Stat.created BETWEEN "' . $date_from_str . '" AND "' . $date_to_str . '"'
            //'Stat.created BETWEEN (NOW() - INTERVAL 30 DAY) AND NOW()'
            ),
            'fields' => array('DATE_FORMAT(Stat.created,"%d-%m-%Y") AS statDate', 'COUNT(DATE_FORMAT(Stat.created,"%d-%m-%Y")) AS statDateCount'),
            'order' => array(
                'Stat.created' => 'DESC'
            ),
            'group' => array('statDate'),
        ));
        $this->set('linksStats', $linksStats);

        $link_countries = $this->Stat->find('all', array(
            'conditions' => array(
                'Stat.user_id' => $this->Auth->user('id'),
                'Stat.created BETWEEN "' . $date_from_str . '" AND "' . $date_to_str . '"'
            ),
            'fields' => array('Stat.country', 'COUNT(Stat.country) AS country_num'),
            'order' => array(
                'country_num' => 'desc'
            ),
            'group' => array('Stat.country'),
        ));
        $this->set('link_countries', $link_countries);

        $link_continents = $this->Stat->find('all', array(
            'conditions' => array(
                'Stat.user_id' => $this->Auth->user('id'),
                'Stat.created BETWEEN "' . $date_from_str . '" AND "' . $date_to_str . '"'
            ),
            'fields' => array('Stat.continent', 'COUNT(Stat.continent) AS continent_num'),
            'order' => array(
                'continent_num' => 'desc'
            ),
            'group' => array('Stat.continent'),
        ));
        $this->set('link_continents', $link_continents);

        $link_states = $this->Stat->find('all', array(
            'conditions' => array(
                'Stat.user_id' => $this->Auth->user('id'),
                'Stat.created BETWEEN "' . $date_from_str . '" AND "' . $date_to_str . '"'
            ),
            'fields' => array('Stat.state', 'COUNT(Stat.state) AS state_num'),
            'order' => array(
                'state_num' => 'desc'
            ),
            'group' => array('Stat.state'),
        ));
        $this->set('link_states', $link_states);

        $link_cities = $this->Stat->find('all', array(
            'conditions' => array(
                'Stat.user_id' => $this->Auth->user('id'),
                'Stat.created BETWEEN "' . $date_from_str . '" AND "' . $date_to_str . '"'
            ),
            'fields' => array('Stat.city', 'COUNT(Stat.city) AS city_num'),
            'order' => array(
                'city_num' => 'desc'
            ),
            'group' => array('Stat.city'),
        ));
        $this->set('link_cities', $link_cities);
    }

    public function members_referrer()
    {
        $this->set('website_title', 'Stat Locations');

        //Transform POST into GET
        if (($this->request->is('post') || $this->request->is('put')) && isset($this->request->data['Filter'])) {
            $date_from = $this->request->data['Filter']['date_from'];
            $date_from_str = $date_from['year'] . '-' . $date_from['month'] . '-' . $date_from['day'] . ' 00:00:00';
            $date_to = $this->request->data['Filter']['date_to'];
            $date_to_str = $date_to['year'] . '-' . $date_to['month'] . '-' . $date_to['day'] . ' 00:00:00';
        } else {
            $this->request->data['Filter']['date_from'] = date('Y-m-d', strtotime('-1 month'));
            $this->request->data['Filter']['date_to'] = date('Y-m-d', strtotime('now'));
            $date_from_str = date('Y-m-d H:i:s', strtotime('last month'));
            $date_to_str = date('Y-m-d H:i:s', strtotime('now'));
        }

        $this->set('date_from_str', $date_from_str);
        $this->set('date_to_str', $date_to_str);


        $link_referrers = $this->Stat->find('all', array(
            'conditions' => array(
                'Stat.user_id' => $this->Auth->user('id'),
                'Stat.created BETWEEN "' . $date_from_str . '" AND "' . $date_to_str . '"'
            ),
            'fields' => array(
                "COUNT(Stat.referer) AS num", "Stat.referer_domain"
            ),
            /*
              'fields' => array(
              "COUNT(Stat.referer) AS num", "SUBSTRING_INDEX(REPLACE(REPLACE(Stat.referer,'http://',''),'https://',''),'/',1) AS domain"
              ),
             */
            'order' => array(
                'num' => 'desc'
            ),
            'group' => array('Stat.referer_domain'),
        ));
        $this->set('link_referrers', $link_referrers);
    }

    public function members_browser()
    {
        $this->set('website_title', 'Stat Locations');

        //Transform POST into GET
        if (($this->request->is('post') || $this->request->is('put')) && isset($this->request->data['Filter'])) {
            $date_from = $this->request->data['Filter']['date_from'];
            $date_from_str = $date_from['year'] . '-' . $date_from['month'] . '-' . $date_from['day'] . ' 00:00:00';
            $date_to = $this->request->data['Filter']['date_to'];
            $date_to_str = $date_to['year'] . '-' . $date_to['month'] . '-' . $date_to['day'] . ' 00:00:00';
        } else {
            $this->request->data['Filter']['date_from'] = date('Y-m-d', strtotime('-1 month'));
            $this->request->data['Filter']['date_to'] = date('Y-m-d', strtotime('now'));
            $date_from_str = date('Y-m-d H:i:s', strtotime('last month'));
            $date_to_str = date('Y-m-d H:i:s', strtotime('now'));
        }

        $this->set('date_from_str', $date_from_str);
        $this->set('date_to_str', $date_to_str);


        $link_browsers = $this->Stat->find('all', array(
            'conditions' => array(
                'Stat.user_id' => $this->Auth->user('id'),
                'Stat.created BETWEEN "' . $date_from_str . '" AND "' . $date_to_str . '"'
            ),
            'fields' => array('Stat.browser', 'COUNT(Stat.browser) AS browser_num'),
            'order' => array(
                'browser_num' => 'desc'
            ),
            'group' => array('Stat.browser'),
        ));
        $this->set('link_browsers', $link_browsers);
    }

    public function members_platform()
    {
        $this->set('website_title', 'Stat Locations');

        //Transform POST into GET
        if (($this->request->is('post') || $this->request->is('put')) && isset($this->request->data['Filter'])) {
            $date_from = $this->request->data['Filter']['date_from'];
            $date_from_str = $date_from['year'] . '-' . $date_from['month'] . '-' . $date_from['day'] . ' 00:00:00';
            $date_to = $this->request->data['Filter']['date_to'];
            $date_to_str = $date_to['year'] . '-' . $date_to['month'] . '-' . $date_to['day'] . ' 00:00:00';
        } else {
            $this->request->data['Filter']['date_from'] = date('Y-m-d', strtotime('-1 month'));
            $this->request->data['Filter']['date_to'] = date('Y-m-d', strtotime('now'));
            $date_from_str = date('Y-m-d H:i:s', strtotime('last month'));
            $date_to_str = date('Y-m-d H:i:s', strtotime('now'));
        }

        $this->set('date_from_str', $date_from_str);
        $this->set('date_to_str', $date_to_str);


        $link_platforms = $this->Stat->find('all', array(
            'conditions' => array(
                'Stat.user_id' => $this->Auth->user('id'),
                'Stat.created BETWEEN "' . $date_from_str . '" AND "' . $date_to_str . '"'
            ),
            'fields' => array('Stat.platform', 'COUNT(Stat.platform) AS platform_num'),
            'order' => array(
                'platform_num' => 'desc'
            ),
            'group' => array('Stat.platform'),
        ));
        $this->set('link_platforms', $link_platforms);
    }

    public function members_language()
    {
        $this->set('website_title', 'Stat Locations');

        //Transform POST into GET
        if (($this->request->is('post') || $this->request->is('put')) && isset($this->request->data['Filter'])) {
            $date_from = $this->request->data['Filter']['date_from'];
            $date_from_str = $date_from['year'] . '-' . $date_from['month'] . '-' . $date_from['day'] . ' 00:00:00';
            $date_to = $this->request->data['Filter']['date_to'];
            $date_to_str = $date_to['year'] . '-' . $date_to['month'] . '-' . $date_to['day'] . ' 00:00:00';
        } else {
            $this->request->data['Filter']['date_from'] = date('Y-m-d', strtotime('-1 month'));
            $this->request->data['Filter']['date_to'] = date('Y-m-d', strtotime('now'));
            $date_from_str = date('Y-m-d H:i:s', strtotime('last month'));
            $date_to_str = date('Y-m-d H:i:s', strtotime('now'));
        }

        $this->set('date_from_str', $date_from_str);
        $this->set('date_to_str', $date_to_str);


        $link_languages = $this->Stat->find('all', array(
            'conditions' => array(
                'Stat.user_id' => $this->Auth->user('id'),
                'Stat.created BETWEEN "' . $date_from_str . '" AND "' . $date_to_str . '"'
            ),
            'fields' => array('Stat.language', 'COUNT(Stat.language) AS num'),
            'order' => array(
                'num' => 'desc'
            ),
            'group' => array('Stat.language'),
        ));
        $this->set('link_languages', $link_languages);
    }

    public function members_device()
    {
        $this->set('website_title', 'Stat Locations');

        //Transform POST into GET
        if (($this->request->is('post') || $this->request->is('put')) && isset($this->request->data['Filter'])) {
            $date_from = $this->request->data['Filter']['date_from'];
            $date_from_str = $date_from['year'] . '-' . $date_from['month'] . '-' . $date_from['day'] . ' 00:00:00';
            $date_to = $this->request->data['Filter']['date_to'];
            $date_to_str = $date_to['year'] . '-' . $date_to['month'] . '-' . $date_to['day'] . ' 00:00:00';
        } else {
            $this->request->data['Filter']['date_from'] = date('Y-m-d', strtotime('-1 month'));
            $this->request->data['Filter']['date_to'] = date('Y-m-d', strtotime('now'));
            $date_from_str = date('Y-m-d H:i:s', strtotime('last month'));
            $date_to_str = date('Y-m-d H:i:s', strtotime('now'));
        }

        $this->set('date_from_str', $date_from_str);
        $this->set('date_to_str', $date_to_str);


        $link_devices = $this->Stat->find('all', array(
            'conditions' => array(
                'Stat.user_id' => $this->Auth->user('id'),
                'Stat.created BETWEEN "' . $date_from_str . '" AND "' . $date_to_str . '"'
            ),
            'fields' => array('Stat.device_type', 'COUNT(Stat.device_type) AS num'),
            'order' => array(
                'num' => 'desc'
            ),
            'group' => array('Stat.device_type'),
        ));
        $this->set('link_devices', $link_devices);
    }

    public function members_mobile()
    {
        $this->set('website_title', 'Stat Locations');

        //Transform POST into GET
        if (($this->request->is('post') || $this->request->is('put')) && isset($this->request->data['Filter'])) {
            $date_from = $this->request->data['Filter']['date_from'];
            $date_from_str = $date_from['year'] . '-' . $date_from['month'] . '-' . $date_from['day'] . ' 00:00:00';
            $date_to = $this->request->data['Filter']['date_to'];
            $date_to_str = $date_to['year'] . '-' . $date_to['month'] . '-' . $date_to['day'] . ' 00:00:00';
        } else {
            $this->request->data['Filter']['date_from'] = date('Y-m-d', strtotime('-1 month'));
            $this->request->data['Filter']['date_to'] = date('Y-m-d', strtotime('now'));
            $date_from_str = date('Y-m-d H:i:s', strtotime('last month'));
            $date_to_str = date('Y-m-d H:i:s', strtotime('now'));
        }

        $this->set('date_from_str', $date_from_str);
        $this->set('date_to_str', $date_to_str);


        $link_brands = $this->Stat->find('all', array(
            'conditions' => array(
                'Stat.user_id' => $this->Auth->user('id'),
                'Stat.created BETWEEN "' . $date_from_str . '" AND "' . $date_to_str . '"',
                'OR' => array(
                    'Stat.is_mobile' => 1,
                    'Stat.is_tablet' => 1
                )
            ),
            'fields' => array('Stat.device_brand', 'COUNT(Stat.device_brand) AS num'),
            'order' => array(
                'num' => 'desc'
            ),
            'group' => array('Stat.device_brand'),
        ));
        $this->set('link_brands', $link_brands);

        $link_device_names = $this->Stat->find('all', array(
            'conditions' => array(
                'Stat.user_id' => $this->Auth->user('id'),
                'Stat.created BETWEEN "' . $date_from_str . '" AND "' . $date_to_str . '"',
                'OR' => array(
                    'Stat.is_mobile' => 1,
                    'Stat.is_tablet' => 1
                )
            ),
            'fields' => array('Stat.device_name', 'COUNT(Stat.device_name) AS num'),
            'order' => array(
                'num' => 'desc'
            ),
            'group' => array('Stat.device_name'),
        ));
        $this->set('link_device_names', $link_device_names);
    }
}
